import 'package:flutter/material.dart';
import 'package:viserpay/core/helper/date_converter.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/core/utils/url_container.dart';
import 'package:viserpay/core/utils/util.dart';
import 'package:viserpay/data/model/savings/savings_response_model.dart';
import 'package:viserpay/view/components/image/my_image_widget.dart';

class NomineeCard extends StatelessWidget {
  final String nomineeImage;
  final Nominee nominee;
  final VoidCallback onSelectPress;
  final VoidCallback onDeletePress;
  final bool isSelected;

  const NomineeCard({
    super.key,
    required this.nominee,
    required this.nomineeImage,
    required this.onDeletePress,
    required this.onSelectPress,
    required this.isSelected,
  });

  @override
  Widget build(BuildContext context) {
    return Stack(
      clipBehavior: Clip.none,
      children: [
        Container(
          padding: EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space15),
          decoration: BoxDecoration(color: MyColor.colorWhite, borderRadius: BorderRadius.circular(Dimensions.largeRadius), border: Border.all(color: MyColor.borderColor, width: .5), boxShadow: MyUtils.getCardShadow()),
          child: Row(
            children: [
              MyImageWidget(
                imageUrl: nomineeImage,
                height: 60,
                width: 60,
                radius: 30,
                isProfile: true,
              ),
              const SizedBox(width: Dimensions.space15),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(nominee.nomineeName ?? "", style: semiBoldDefault.copyWith()),
                    Text(DateConverter.estimatedDateYMD(DateTime.parse(nominee.nomineeBirthDate ?? "")), style: lightDefault.copyWith()),
                  ],
                ),
              ),
              Radio(
                value: isSelected,
                groupValue: true,
                activeColor: MyColor.primaryColor,
                fillColor: WidgetStateProperty.all(MyColor.primaryColor),
                onChanged: (value) {
                  onSelectPress();
                },
                materialTapTargetSize: MaterialTapTargetSize.padded,
              ),
            ],
          ),
        ),
        Positioned(
          top: -10,
          right: -5,
          child: InkWell(
            onTap: onDeletePress,
            customBorder: CircleBorder(),
            child: Container(
              padding: EdgeInsets.all(5),
              decoration: BoxDecoration(
                color: MyColor.redCancelTextColor,
                shape: BoxShape.circle,
              ),
              child: Icon(Icons.close, color: MyColor.colorWhite, size: 14),
            ),
          ),
        ),
      ],
    );
  }
}
